﻿var companies = {
    context: $(".v-companies"),
    canModifySettings: $("#ModifyReportingAccess").val() == "True",
    datatable: null,
    refreshDataTable: function () {
        companies.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-companiesTable").a4datatable({
            advancedFilter: true,
            height: "full",
            stateKey:"ReportingPortalCompanies",
            ajaxAction: a4.getAction("GetCompanies", "Reporting", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Key": true},
                { "Name": "Name", "Title": resources.Name, "Data": "Name", "HideInSelector": true },
                { "Name": "FirstName", "Title": resources.FirstName, "Data": "FirstName" },
                { "Name": "LastName", "Title": resources.LastName, "Data": "LastName" },
                { "Name": "Email", "Title": resources.Email, "Data": "Email" },
                { "Name": "PhoneNumber", "Title": resources.PhoneNumber, "Data": "PhoneNumber" }
            ],
            localizableTexts: { "Search": resources.SearchCompanies },
            toolBarItems: companies.getToolBarItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.map(rows, function (row) { return row.Id });

                switch (action) {
                    case "delete":
                        companies.deleteItems(ids);
                        break;
                }
            },
            contextMenuItems: companies.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                var id = [row.Id];

                switch (action) {
                    case "properties":
                        modalDialog.showWindow(a4.getAction("EditCompany", "Reporting", "Settings", { id: row.Id }), 450, 600, { afterClose: function () { companies.refreshDataTable(); } });
                        break;
                    case "delete":
                        companies.deleteItems(id);
                        break;
                }
            }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addCompany", function () {
            modalDialog.showWindow(a4.getAction("EditCompany", "Reporting", "Settings"), 500, 600, { afterClose: function () { companies.refreshDataTable(); } });
        });
    },
    deleteItems: function (items) {
        modalDialog.showConfirmDelete(confirmDeleteItemResources, function () {
            a4.callServerMethod(a4.getAction("DeleteCompanies", "Reporting", "Settings"), { ids: items },
                function (result) {
                    companies.refreshDataTable();
                });
        }, items.length);
    },
    getContextMenuItems: function () {
        var items = [];
        if (this.canModifySettings) {
            items = [                
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "properties", "Label": resources.Properties }
            ]
        }
        return items;
    },
    getToolBarItems: function () {
        var items = [];
        if (this.canModifySettings) {
            items = [
               { "Action": "delete", "Label": resources.Delete }
            ]
        }
        return items;
    }
}

$(document).ready(function () {
    if (companies.context.length > 0) {
        companies.initializeDataTable();
        companies.bindEvents();
    }
});